/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.tileentity;

import javax.annotation.Nonnull;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.BlockBookshelf;
import knightminer.inspirations.building.client.GuiBookshelf;
import knightminer.inspirations.building.inventory.ContainerBookshelf;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.InventorySlotSyncPacket;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.client.ClientUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.tileentity.TileInventory;

public class TileBookshelf
extends TileInventory
implements IInventoryGui {
    private float enchantBonus = Float.NaN;

    public TileBookshelf() {
        super("gui.inspirations.bookshelf.name", 14, 1);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        ItemStack oldStack = this.func_70301_a(slot);
        if (this.func_145831_w() != null && this.func_145831_w() instanceof WorldServer && !this.func_145831_w().field_72995_K && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            InspirationsNetwork.sendToClients((WorldServer)this.func_145831_w(), this.field_174879_c, (AbstractPacket)new InventorySlotSyncPacket(itemstack, slot, this.field_174879_c));
        }
        super.func_70299_a(slot, itemstack);
        if (this.func_145831_w() != null) {
            if (this.func_145831_w().field_72995_K) {
                Minecraft.func_71410_x().field_71438_f.func_184376_a(null, this.field_174879_c, null, null, 0);
            }
            if (InspirationsBuilding.redstoneBook != null && InspirationsBuilding.redstoneBook.func_77969_a(oldStack) ^ InspirationsBuilding.redstoneBook.func_77969_a(itemstack)) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (state.func_177230_c() == this.func_145838_q()) {
                    this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockBookshelf.FACING)).func_176734_d()), this.func_145838_q(), false);
                }
            }
        }
        this.enchantBonus = Float.NaN;
    }

    public boolean interact(EntityPlayer player, EnumHand hand, int bookClicked) {
        if (this.isStackInSlot(bookClicked)) {
            if (!this.field_145850_b.field_72995_K) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.func_70301_a(bookClicked), (int)player.field_71071_by.field_70461_c);
                this.func_70299_a(bookClicked, ItemStack.field_190927_a);
            }
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (InspirationsRegistry.isBook(stack)) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70299_a(bookClicked, stack.func_77979_a(1));
            }
            return true;
        }
        return false;
    }

    public ContainerBookshelf createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerBookshelf(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiBookshelf(this.createContainer(inventoryplayer, world, pos));
    }

    public int getPower() {
        if (InspirationsBuilding.redstoneBook == null) {
            return 0;
        }
        for (int i = 0; i < 14; ++i) {
            if (!InspirationsBuilding.redstoneBook.func_77969_a(this.func_70301_a(i))) continue;
            return i + 2;
        }
        return 0;
    }

    public float getEnchantPower() {
        if (!Float.isNaN(this.enchantBonus)) {
            return this.enchantBonus;
        }
        float books = 0.0f;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            float power;
            if (!this.isStackInSlot(i) || !((power = InspirationsRegistry.getBookEnchantingPower(this.func_70301_a(i))) >= 0.0f)) continue;
            books += power;
        }
        this.enchantBonus = books / 14.0f;
        return this.enchantBonus;
    }

    public IBlockState writeExtendedBlockState(IExtendedBlockState state) {
        int books = 0;
        for (int i = 0; i < 14; ++i) {
            if (!this.isStackInSlot(i)) continue;
            books |= 1 << i;
        }
        state = state.withProperty(BlockBookshelf.BOOKS, (Object)books);
        String texture = ClientUtil.getTexturePath((TileEntity)this);
        if (!texture.isEmpty()) {
            state = state.withProperty((IUnlistedProperty)BlockBookshelf.TEXTURE, (Object)texture);
        }
        return state;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.getTileData().func_74737_b();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        NBTBase texture = tag.func_74781_a("texture");
        if (texture != null) {
            this.getTileData().func_74782_a("texture", texture);
        }
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        NBTTagCompound forgeData = tags.func_74775_l("ForgeData");
        if (forgeData.func_150297_b("texture", 8)) {
            forgeData.func_74778_a("texture_path", forgeData.func_74779_i("texture"));
            forgeData.func_82580_o("texture");
        }
    }
}

